defmodule DaProductApp.Repo.Migrations.RecreateProvidersWithAutoIncrementId do
  use Ecto.Migration

  def change do
    # Drop the existing providers table
    drop table(:providers)

    # Recreate the providers table with an auto-incrementing integer ID
    create table(:providers, primary_key: true) do
      add :name, :string, null: false
      add :status, :string, default: "enable", null: false
      add :production_url, :string
      add :production_mode, :string, default: "enable", null: false
      add :description, :text

      timestamps()
    end
  end
end